IF EXISTS (SELECT * FROM SYS.PROCEDURES WHERE NAME = 'P_LGPD_PROCESSAMENTO_CLI')
BEGIN 
	DROP PROCEDURE P_LGPD_PROCESSAMENTO_CLI
END 

GO 

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 21081901
'Job.................:  
'Nome................: P_LGPD_PROCESSAMENTO_CLI 
'Objetivo............: Procedure responsavel pela anonimização de clientes - LGPD 
'Tabelas.............: RC_CLI, EST_PED_VD, RC_CLI_AUDIT, EST_NF_SAI, LGPD_LOG_PROCESSAMENTO  
'Dt Criação..........: 
'Dt Ult Alteracão....: 15/09/2021
'Alterado por........: Marcos barros
'Criado por..........: Rayane
'=======================================================================================
Reg #21081901 - Alteração retorno RAISERROR  - Marcos Barros
Reg #21081901 - Alteração estrutura de insert em @NAO_ANONIMIZAR_DADOS - Marcos Barros
*/

CREATE PROCEDURE P_LGPD_PROCESSAMENTO_CLI (@CD_CLI INT )
WITH ENCRYPTION
AS 
	SET NOCOUNT ON 
	
	DECLARE @NAO_ANONIMIZAR_DADOS TABLE (CD_CLI INT, DESCRICAO VARCHAR(1000));
	
	--Desabilita Trigges de bloqueio por pendencia 
	DISABLE TRIGGER dbo.TRG_EST_PED_VD_INCLUI_EXCLUI_PENDENCIA ON dbo.EST_PED_VD;  
	DISABLE TRIGGER dbo.TRG_EST_NF_SAI_INCLUI_EXCLUI_PENDENCIA ON dbo.EST_NF_SAI;  
	
	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT 
		RC_DEB.CD_CLI, 
		('NÃO PODE SER ANONIMIZADO: CLIENTE - ' + CAST(@CD_CLI AS VARCHAR) + ' COM TÍTULOS EM ABERTO - DEB') AS DESCRICAO
    FROM RC_DEB RC_DEB
			JOIN RC_CLI ON RC_DEB.CD_EMP = RC_CLI.CD_EMP
				AND RC_DEB.CD_CLI = RC_CLI.CD_CLI 
	WHERE RC_DEB.CD_EMP  = 1 
	   AND RC_DEB.STS_DP  IN (0,2,5)
	   AND RC_CLI.CD_CLI  = @CD_CLI
	   AND RC_CLI.PESSOA  = 0 
	 
	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT  
		EST_PED_VD.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: CLIENTE - ' + CAST(@CD_CLI AS VARCHAR) + ' COM ORÇAMENTO/TELE, VENDAS/PRÉ OU FATURA EM ABERTO') AS DESCRICAO
	FROM EST_PED_VD
			JOIN RC_CLI ON EST_PED_VD.CD_EMP = RC_CLI.CD_EMP 
				AND EST_PED_VD.CD_CLI = RC_CLI.CD_CLI 
	WHERE EST_PED_VD.CD_EMP = 1 
	  AND EST_PED_VD.STS_PED =0
	  AND RC_CLI.CD_CLI  = @CD_CLI
	  AND RC_CLI.PESSOA = 0 
	 
	INSERT INTO @NAO_ANONIMIZAR_DADOS 
	SELECT  
		RC_CLI.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: CLIENTE - ' + CAST(@CD_CLI AS VARCHAR) + ' COM CHEQUE E ESTÁ EM ABERTO - CHEQUE') AS DESCRICAO
	FROM PDV_VD
		JOIN PDV_VD_CHQS ON PDV_VD.CD_EMP    = PDV_VD_CHQS.CD_EMP   
			AND PDV_VD.CD_FILIAL = PDV_VD_CHQS.CD_FILIAL
			AND PDV_VD.CD_VD     = PDV_VD_CHQS.CD_VD  
		JOIN PDV_VD_CHQS_CHQ_LANC ON PDV_VD_CHQS.CD_EMP    = PDV_VD_CHQS_CHQ_LANC.CD_EMP   						
 			AND PDV_VD_CHQS.CD_FILIAL = PDV_VD_CHQS_CHQ_LANC.CD_FILIAL
			AND PDV_VD_CHQS.CD_VD     = PDV_VD_CHQS_CHQ_LANC.CD_VD  
			AND PDV_VD_CHQS.NR_ORD    = PDV_VD_CHQS_CHQ_LANC.NR_ORD  
		JOIN CHQ_LANC_CPL ON CHQ_LANC_CPL.CD_EMP = PDV_VD_CHQS_CHQ_LANC.CD_EMP
			AND CHQ_LANC_CPL.CD_CHQ = PDV_VD_CHQS_CHQ_LANC.CD_CHQ
		JOIN RC_CLI ON RC_CLI.CD_EMP = PDV_VD.CD_EMP
			AND RC_CLI.CD_CLI = PDV_VD.CD_CLI 
    WHERE PDV_VD.CD_EMP = 1  
		AND RC_CLI.CD_CLI = @CD_CLI
		AND RC_CLI.PESSOA =  0
		AND CHQ_LANC_CPL.STS_CHQ IN (0,1,2,5,6,7,9)
	   
	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT 
		RC_CLI.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: CLIENTE - ' + CAST(@CD_CLI AS VARCHAR) + ' COM TÍTULOS EM ABERTO - CONVENIADO') AS DESCRICAO
	FROM RC_CLI_CONV_RC_CLI 
			JOIN RC_CLI ON RC_CLI.CD_EMP = RC_CLI_CONV_RC_CLI.CD_EMP
				AND RC_CLI.CD_CLI = RC_CLI_CONV_RC_CLI.CD_CLI
	  WHERE RC_CLI.CD_EMP = 1 
	    AND RC_CLI.CD_CLI = @CD_CLI
	    AND RC_CLI_CONV_RC_CLI.VLR_DEB > 0
	    AND RC_CLI.PESSOA =  0
	   
	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT 
		RC_CLI.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: CLIENTE - ' + CAST(@CD_CLI AS VARCHAR) + ' COM ORÇAMENTO/TELE VENDAS/PRÉ FATURA EM ABERTO/CHEQUE') AS DESCRICAO
	FROM RC_CLI_CREDIARIO 
			JOIN RC_CLI ON RC_CLI.CD_EMP = RC_CLI_CREDIARIO.CD_EMP
				AND RC_CLI.CD_CLI = RC_CLI_CREDIARIO.CD_CLI
	WHERE RC_CLI.CD_EMP = 1 
		AND RC_CLI.CD_CLI = @CD_CLI
		AND RC_CLI_CREDIARIO.VLR_DEB_CRED > 0
		AND RC_CLI.PESSOA =  0
	   
	INSERT INTO @NAO_ANONIMIZAR_DADOS
	SELECT 
		RC_CLI.CD_CLI,
		('NÃO PODE SER ANONIMIZADO: CLIENTE - ' + CAST(@CD_CLI AS VARCHAR) + ' COM TÍTULOS EM ABERTO - NOTA SAIDA') AS DESCRICAO
	FROM EST_NF_SAI 
		JOIN RC_CLI ON EST_NF_SAI.CD_CLI = RC_CLI.CD_CLI
	WHERE EST_NF_SAI.STS_NF= 0 
	    AND RC_CLI.PESSOA = 0 
		AND RC_CLI.CD_CLI = @CD_CLI
		AND NOT EXISTS (SELECT 
							CD_CTR_ARQ 
						FROM 
							EST_NF_SAI_ARQ_DANFE 
						WHERE 
							EST_NF_SAI_ARQ_DANFE.CD_EMP    = EST_NF_SAI.CD_EMP 
							AND EST_NF_SAI_ARQ_DANFE.CD_FILIAL = EST_NF_SAI.CD_FILIAL 
							AND EST_NF_SAI_ARQ_DANFE.CD_NF     = EST_NF_SAI.CD_NF)

	
	--Retorno pendencia existente
	IF EXISTS (SELECT 1 FROM @NAO_ANONIMIZAR_DADOS WHERE CD_CLI = @CD_CLI )
	BEGIN
		UPDATE RC_CLI SET ACEITE_LGPD = 3 where CD_CLI = @CD_CLI;

		DECLARE @ERRORMESSAGE VARCHAR(MAX)= (SELECT DESCRICAO FROM ( SELECT T.DESCRICAO, ROW_NUMBER() OVER(ORDER BY CD_CLI DESC) AS RowNumber FROM @NAO_ANONIMIZAR_DADOS T WHERE CD_CLI = @CD_CLI ) AS tmp WHERE RowNumber = 1);
		RAISERROR (@ERRORMESSAGE, 16, 1);
		RETURN;
	END
	ELSE
		UPDATE RC_CLI SET ACEITE_LGPD = 2 where CD_CLI = @CD_CLI;
	
/* ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/	
 	 
			PRINT 'ANONIMIZANDO CLIENTE';

				 UPDATE RC_CLI	 
				    SET RZ_CLI		='ANONIMIZADO'
				      , NM_FANT	    ='ANONIMIZADO'
				      , CGC_CPF	    ='000000000000'
				      , END_CLI		='ANONIMIZADO'
				      , DDD_TEL		='00'
				      , TEL			='0000000000'
				      , DDD_FAX		='00'
				      , FAX			='0000000000'
				      , CONTATO		='0000000000'
				      , EMAIL		='ANONIMIZADO@ANONIMIZADO'
				      , CONTATO_COB	='0000000000'
				      , EMAIL_COB	='ANONIMIZADO@ANONIMIZADO'
				      , DDD_TEL_COB	='0000000000'
				      , TEL_COB		='0000000000'
				      , DDD_FAX_COB	='00'
				      , FAX_COB		='0000000000'
				      , RAMAL_COB	='00'
				      , END_COB		='ANONIMIZADO'
				      , PONTO_REF	='ANONIMIZADO'
				      , DD1			='0000000000'
				      , DD2			='0000000000'
				      , DD3			='0000000000'
				      , TELEFONE1	='0000000000'
				      , TELEFONE2	='0000000000'
				      , TELEFONE3	='0000000000'
				      , RG			=''
				      , COMPLEMENTO	='ANONIMIZADO'
				      , NM_MAE		='ANONIMIZADO'
					  , NM_PAI		='ANONIMIZADO'
				      , COMPLEMENTO_RESIDENCIAL		='ANONIMIZADO'
				      , NR_CARTAO_ANTIGO			='ANONIMIZADO'
				      , NUMERO						='ANONIMIZADO'
				      , COMPLE_COBRANCA				='ANONIMIZADO'
				      , NUMER_COBRANCA				='ANONIMIZADO'
					  , ACEITE_LGPD					=2

 			 FROM RC_CLI
			WHERE CD_CLI = @CD_CLI
			  AND RC_CLI.PESSOA = 0;


			UPDATE EST_PED_VD	
			 SET CGC_CPF_TRANSP			='000000000000'
				,EMAIL_TRANSP			='ANONIMIZADO@ANONIMIZADO'
				,PONTO_REF_DESTINATARIO	='ANONIMIZADO' 
			 WHERE CD_CLI = @CD_CLI ;

			 UPDATE RC_CLI_AUDIT	
			    SET  RZ_CLI		=''
					,NM_FANT	=''
					,END_CLI	=''
					 
			  WHERE CD_CLI = @CD_CLI ;

			 UPDATE EST_NF_SAI	
				SET  CGC_CPF_TRANSP			='000000000000' 
					,EMAIL_TRANSP			='ANONIMIZADO@ANONIMIZADO'
					,PONTO_REF_DESTINATARIO ='ANONIMIZADO'
					,EMAIL					='ANONIMIZADO@ANONIMIZADO'
			  WHERE EST_NF_SAI.CD_CLI = @CD_CLI;
		

		INSERT INTO LGPD_LOG_PROCESSAMENTO   (CD_PESSOA,DT_CAD,NM_FM,TP_PROC)
		SELECT @CD_CLI					AS CD_PESSOA, 
			   GETDATE()				AS DT_CAD,
			   'P_LGPD_PROCESSAMENTO_CLI'	AS NM_FM,
			   0						AS TP_PROC;

		--habilita Trigges de bloqueio por pendencia 
		ENABLE TRIGGER dbo.TRG_EST_PED_VD_INCLUI_EXCLUI_PENDENCIA ON dbo.EST_PED_VD; 
		ENABLE TRIGGER dbo.TRG_EST_NF_SAI_INCLUI_EXCLUI_PENDENCIA ON dbo.EST_NF_SAI;  

		 
